import subprocess
import os
# Print the current working directory for debugging
print(f"Current working directory: {os.getcwd()}")

print("This library is a fork of our other project the cobrennium project it converts a existing python file to batch file")
print("Type 'convert' to convert a specific Python file to a batch file or 'delete' to uninstall the library and any files associated with it (warning this will permanently delete the script file and batch file used to make the script work unless you redownload the script from our website again")
choice = input("Enter choice: ").strip().lower()

if choice == "convert":
    file_name = input("Enter the name of the Python file (or full path): ").strip()

    # Get the absolute path of the specified Python file
    full_path = os.path.abspath(file_name)

    # Check if the file exists
    if os.path.isfile(full_path):
        # Extract the base file name without the extension for batch file naming
        base_name = os.path.splitext(os.path.basename(full_path))[0]
        batch_file_path = 'convertpytobat.bat'

        # Create the batch file
        with open(batch_file_path, 'w') as batch_file:
            batch_file.write('@echo off\n')
            batch_file.write(f'echo @echo off > "{base_name}.bat"\n')
            batch_file.write(f'echo python "{full_path}" >> "{base_name}.bat"\n')

        # Execute the batch file
        try:
            subprocess.run(batch_file_path, shell=True, check=True)
            print(f"Batch file '{base_name}.bat' created and executed successfully!")
        except subprocess.CalledProcessError as e:
            print(f"Error executing batch file: {e}")
    else:
        print("Python file not found!")
elif choice == "delete":
    # Get the current script name
    current_script_name = os.path.basename(__file__)
    batch_file_name = 'convertpytobat.bat'

    # Delete the batch file
    if os.path.isfile(batch_file_name):
        os.remove(batch_file_name)
        print(f"Deleted batch file: {batch_file_name}")

    # Delete the current script
    os.remove(current_script_name)
    print(f"Deleted script file: {current_script_name}")

else:
    print("Invalid choice. Please enter 'convert' or 'show code'.")

print("copyright scriptcobra.com this script is open source")
input("Press Enter to exit...")  # Used to make the script not end immediately